/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.items.tooltips;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.tooltip.ITooltipFunction;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionTooltipBase;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class ActionRemoveRegexTooltip
extends ActionTooltipBase {
    private final Pattern regex;
    private final ITooltipFunction function;

    public ActionRemoveRegexTooltip(IIngredient stack, Pattern regex) {
        super(stack);
        this.regex = regex;
        this.function = (stack1, tooltip, isAdvanced) -> {
            ArrayList<MCTextComponent> content = new ArrayList<MCTextComponent>();
            for (MCTextComponent component : tooltip) {
                if (regex.matcher(component.getFormattedText()).find()) continue;
                content.add(component);
            }
            tooltip.clear();
            tooltip.addAll(content);
        };
    }

    @Override
    public void apply() {
        this.getTooltip().add(this.function);
    }

    @Override
    public void undo() {
        this.getTooltip().remove(this.function);
    }

    @Override
    public String describe() {
        return "Removing from the tooltip for: " + this.stack.getCommandString() + " based on the regex: \"" + this.regex + "\"";
    }

    @Override
    public String describeUndo() {
        return "Undoing removal from the tooltip for: " + this.stack.getCommandString() + " based on the regex: \"" + this.regex + "\"";
    }
}

